<?php
/**
 * Mark Course
 *
 * @package     AutomatorWP\Integrations\LearnPress\Actions\Mark_Course
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_LearnPress_Mark_Course extends AutomatorWP_Integration_Action {

    public $integration = 'learnpress';
    public $action = 'learnpress_mark_course';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Mark course as completed for the user', 'automatorwp-pro' ),
            'select_option'     => __( 'Mark <strong>course as completed</strong> for the user', 'automatorwp-pro' ),
            /* translators: %1$s: Post title. */
            'edit_label'        => sprintf( __( 'Mark %1$s as completed for the user', 'automatorwp-pro' ), '{post}' ),
            /* translators: %1$s: Post title. */
            'log_label'         => sprintf( __( 'Mark %1$s as completed for the user', 'automatorwp-pro' ), '{post}' ),
            'options'           => array(
                'post' => automatorwp_utilities_post_option( array(
                    'name'              => __( 'Course:', 'automatorwp-pro' ),
                    'option_default'    => __( 'course', 'automatorwp-pro' ),
                    'placeholder'       => __( 'Select a course', 'automatorwp-pro' ),
                    'option_none'       => false,
                    'option_custom'         => true,
                    'option_custom_desc'    => __( 'Course ID', 'automatorwp-pro' ),
                    //'post_type'         => LP_COURSE_CPT,
                    'post_type'         => 'lp_course',
                ) ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $course_id = absint( $action_options['post'] );

        // Bail if not course provided
        if( $course_id === 0 ) {
            return;
        }

        $user = learn_press_get_user( $user_id );

        // Bail if can't find the user
        if( ! $user ) {
            return;
        }

        //$user_course = $user->get_course_data( $course_id );

        $course = learn_press_get_course( $course_id );

        // Check if user is enrolled in course
        if ( ! $user->has_enrolled_course( $course_id ) ) {
            return;
        }

        $course = learn_press_get_course( $course_id );

        $sections = $course->get_curriculum_raw();


        if ( ! empty( $sections ) ) {

            // Loop all course sections to mark them as completed
            foreach ( $sections as $section ) {

                // Skip if section has no items
                if ( ! isset( $section['items'] ) ) {
                    continue;
                }

                if( ! is_array( $section['items'] ) ) {
                    continue;
                }

                // Mark section items as completed
                foreach ( $section['items'] as $item ) {

                    switch ( $item['type'] ) {
                        case LP_LESSON_CPT:
                            // Get lesson item related to course
                            $item_lesson = $course->get_item( $item['id'] );
                            // Create view in database
                            $created_view = $user->set_viewing_item( $item_lesson );
                            // Mark lesson as completed
                            $result = $user->complete_lesson( absint( $item['id'] ), $course_id );
                            break;
                        case LP_QUIZ_CPT:
                            if ( ! $user->has_item_status( array( 'started', 'completed' ), $item['id'], $course_id ) ) {
                                // If user has not started this quiz yet, force its start
                                $quiz_data = $user->start_quiz( $item['id'], $course_id, false );
                                $quiz = new LP_User_Item_Course( $quiz_data );
                            } else {
                                $quiz = $user->get_item_data( $item['id'], $course_id );
                            }

                            // Mark quiz as completed
                            $result = $user->finish_quiz( absint( $item['id'] ), $course_id );
                            break;
                    }

                }
            }

        }

        $user_course = $user->get_course_data( $course_id );

        // Mark course as completed
        $user->finish_course( $course_id );

    }

}

new AutomatorWP_LearnPress_Mark_Course();